CREATE DATABASE 'mnogosearch.gdb';


CREATE GENERATOR rec_id_GEN;


CREATE TABLE url (
  rec_id          INT                  NOT NULL PRIMARY KEY,
  url             CHAR(128) DEFAULT '' NOT NULL,
  status          INT       DEFAULT  0 NOT NULL,
  hops            INT       DEFAULT  0 NOT NULL,
  crc32           INT       DEFAULT  0 NOT NULL,
  docsize         INT       DEFAULT  0 NOT NULL,
  next_index_time INT       DEFAULT  0 NOT NULL,
  last_mod_time   INT       DEFAULT  0 NOT NULL,
  referrer        INT       DEFAULT  0 NOT NULL,
  seed            INT       DEFAULT  0 NOT NULL,
  bad_since_time  INT       DEFAULT  0 NOT NULL,
  content_type    CHAR(64)  DEFAULT '' NOT NULL,
  tag             CHAR(16)  DEFAULT '' NOT NULL,
  category        CHAR(16)  DEFAULT '' NOT NULL,
  lang            CHAR(32)  DEFAULT '' NOT NULL,
  charset         CHAR(40)  DEFAULT '' NOT NULL
);

CREATE INDEX         url_crc  ON url (crc32);
CREATE INDEX         url_seed ON url (seed);
CREATE UNIQUE  INDEX url_url  ON url (url);



CREATE TABLE urlinfo (
  url_id  INT           NOT NULL,
  sname   VARCHAR(64)   NOT NULL,
  sval    VARCHAR(1024) NOT NULL
);

CREATE INDEX urlinfo_id ON urlinfo (url_id);




CREATE TABLE dict (
  word     VARCHAR(32) NOT NULL,
  url_id   INT      NOT NULL,
  intag    INT      NOT NULL
);

CREATE   INDEX dict_url_id  ON dict (url_id);
CREATE   INDEX dict_word    ON dict (word);



CREATE TABLE qtrack (
  qwords  varchar(63) DEFAULT '' NOT NULL,
  ip      varchar(16) DEFAULT '' NOT NULL,
  qtime   int         DEFAULT 0  NOT NULL,
  found   int         DEFAULT 0  NOT NULL,
  ps      int         DEFAULT 0  NOT NULL,
  np      int         DEFAULT 0  NOT NULL,
  m       varchar(63) DEFAULT '' NOT NULL,
  wm      varchar(63) DEFAULT '' NOT NULL,
  o       int         DEFAULT 0  NOT NULL,
  t       varchar(63) DEFAULT '' NOT NULL,
  cat     varchar(63) DEFAULT '' NOT NULL,
  ul      varchar(63) DEFAULT '' NOT NULL,
  wf      varchar(63) DEFAULT '' NOT NULL,
  g       varchar(63) DEFAULT '' NOT NULL,
  tmplt   varchar(63) DEFAULT '' NOT NULL
);
